#version 130
#extension GL_EXT_gpu_shader4 : enable
//merging sine tubesMod01.fsh  by   LobsterCrew  

//https://www.shadertoy.com/view/tsKSWV
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

float f(float x, float y)
{
    float arg = .9*iTime + 13.*y + 2.*sin(.3*iTime + 4.*x) - 20.*(x+.5)*y;
	return clamp(.7*cos(arg) + .2*cos(3.*arg) + .05*cos(5.*arg), -1., 1.);
}

float g(float x, float y)
{
    float arg = .9*iTime + 15.*x*1.+ .5*cos(.1*iTime) + 2.*cos(1.2*iTime + 10.*y);
	return clamp(-abs(.5*cos(arg)) + .7*cos(3.*arg) + .3*cos(5.*arg- 1.), -1., 1.);
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    // Normalized pixel coordinates
    vec2 q =(fragCoord - 0.5*iResolution.xy)/iResolution.y;
    vec2 res = vec2(f(q.x, q.y), g(q.x, q.y));
    vec3 col = vec3(.0, .0, .5) + vec3( -1., .0, .5)*sqrt(res.x)*res.y;
    col += vec3(.0, 1., .0)*res.x*res.x * res.y*res.y;
    
    // Output to screen
    fragColor = vec4(col,1.0);
    return fragColor; 
}
///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.